alter PROCEDURE [dbo].[mnrPrcRepEInvoice]
	@AccID		 UNIQUEIDENTIFIER = 0x0,
	@CustID		 UNIQUEIDENTIFIER = 0x0,
	@CostJobID   UNIQUEIDENTIFIER = 0x0,
	@SaleManID   UNIQUEIDENTIFIER = 0x0,
	@BranchID    UNIQUEIDENTIFIER = 0x0,
	@RepSrcID    UNIQUEIDENTIFIER = '{5A273318-C4BB-43fd-86D5-F8D872CC0C97}',
	@CurrencyID  UNIQUEIDENTIFIER = '{DA4DF719-46FD-47af-9876-31D3C4F56751}',
	@FromDate	 DATETIME		  = '1-1-2021',
	@ToDate      DATETIME		  =   '12-27-2023',
	@EBillType   INT			  = 2 ,-- 
	@SentStatus  INT			  = 0 ,-- 1 = sent , 2 = not sent , 0 = both
	@BillStatus  INT			  = 0 -- eygpt 0 = valid , 1 = not valid ,  2 = not known , 3 = all  , seyrian 0 = accpeted - 1 = rejected - 2 = all

	AS
	 Set NOCOUNT ON 

--@EBillType     Sauid:   0 = simple , 1 = normal taxed , 2 = both
						  --- 0 = bill simple
						  --- 1 = bill taxed
						  --- 2 = credit not  simple
						  --- 3 = credit not  taxed
						  --- 4  all

             --  Egypt:   0 = simple , 1 = normal taxed , 2 = both
			 --  syrian:   not found
-------------------------------
   --@BillStatus   Eygpt  :  "Unknown" = 1 , "Invalid"=2  , "Submitted"=3 , "Valid" =4    0 all
   --              Saudi  :  "CLEARED"=  1,"NOT_CLEARED"= 2,"REPORTED" 3,"NOT_REPORTED" 4  0 all
   --              syrian :1  accept ,2 reject   0 all
   --@BillStatus :"CLEARED"=  1 "REPORTED" 3------->(1)
                  --"NOT_CLEARED"= 2 "NOT_REPORTED" 4 ------>(2)

	 DECLARE @bCoreFlag  bit;	

			SET @bCoreFlag = (
				SELECT CASE 
				 WHEN CHARINDEX('core', value) > 0 THEN 1
				 ELSE 0
			END
		FROM mnrFileInfo
		WHERE Type = 'EINVOICE_URL');

		PRINT @bCoreFlag
-------------------------------
---1 ejypt   -2 saudi   -5 syrian 
	 declare @Systemflag int 
	 select @Systemflag =value from mnrfileinfo where type = 'EINVOICE_TAXSYSTEM'
	--select @Systemflag

	 -- ******************* #Acc ************************** --

	CREATE TABLE #Acc( AccID 	       UNIQUEIDENTIFIER , 
					   CustID	       UNIQUEIDENTIFIER NULL, 
					   CustCode        NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					   CustName        NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					   CustLName       NVARCHAR(512)  COLLATE Arabic_CI_AI NULL,
					   AccCode         NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					   AccTaxCode      NVARCHAR(256)  COLLATE Arabic_CI_AI NULL,
					   AccName         NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					   AccLName        NVARCHAR(512)  COLLATE Arabic_CI_AI NULL,
					   )

	INSERT INTO #Acc
	SELECT 
		ISNULL(a.ID,0x0),
		ISNULL(a.CustID,0x0),
		c.Number , 
		c.Name,
		c.LatinName,
		a.Code,
		a.TaxCode,
		a.Name,
		a.LatinName
	FROM
		mnrAcc a
		LEFT JOIN mnrCust c on c.ID = a.CustID
	where 
		(a.ID = @AccID  or @AccID = 0x0) and ( a.CustID = @CustID or @CustID = 0x0  )

	IF( @AccID = 0x0 and @CustID = 0x0) 
		INSERT INTO #Acc SELECT 0x0 , 0x0 ,'','','' , '','','',''

	 -- ******************* #CostJob ************************** --

	CREATE TABLE #CostJob(ID	UNIQUEIDENTIFIER)

	INSERT INTO #CostJob
	SELECT 
		ISNULL(co.ID,0x0)
	FROM
		[mnrCostJob] [co]
		INNER JOIN [dbo].[mnrSysFnGetCostJobList]( @CostJobID) AS [fco] ON [fco].[ID] = [co].[ID]
		
	IF( @CostJobID = 0x0) 
		INSERT INTO #CostJob SELECT 0x0		

	-- ******************* #SaleMan ************************** --

	CREATE TABLE #SellMan(
	                      ID	UNIQUEIDENTIFIER,
						  Code        NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					      Name        NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					      LName       NVARCHAR(512)  COLLATE Arabic_CI_AI NULL
						  )
	INSERT INTO #SellMan
	SELECT 
		ISNULL(sm.ID,0x0) ,
		sm.Code,
		sm.Name,
		sm.LatinName
	FROM
		[mnrSellMan] [sm]
		INNER JOIN [dbo].[mnrSysFnGetSellManList]( @SaleManID) AS [fsm] ON [fsm].[ID] = [sm].[ID]
		
	IF( @SaleManID = 0x0)
		INSERT INTO #SellMan SELECT 0x0,'','',''

	--	select * from #SellMan
-- ******************* #STORE ************************** --
CREATE TABLE #Store(
                    ID UNIQUEIDENTIFIER,
					Code nvarchar(256) collate Arabic_CI_AI,
					Name nvarchar(256) collate Arabic_CI_AI,
					LName nvarchar(256) collate Arabic_CI_AI
					)
		INSERT INTO #Store
			SELECT [st].ID,
			       [st].[Code],
				   [st].[Name],
				   [st].[LatinName]
			FROM 
				mnrStore AS st 

              INSERT INTO #Store SELECT 0x0,'','',''

			  --SELECT * FROM #Store

		-- ******************* #Branch ************************** --
	 declare @CommercialRegistrationNum NVARCHAR(512) 
	 select @CommercialRegistrationNum =value from mnrfileinfo where type = 'COMPANY_COMMERCIALREG'

	CREATE TABLE #Branch(
	                      ID	UNIQUEIDENTIFIER,
						  Code        NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					      Name        NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					      LName       NVARCHAR(512)  COLLATE Arabic_CI_AI NULL,
						  CommercialRegistrationNum         NVARCHAR(512) COLLATE Arabic_CI_AI NULL,
						  )
	INSERT INTO #Branch
	SELECT 
		ISNULL(br.ID,0x0) ,
		br.Code,
		br.Name,
		br.LatinName,
		br.CommercialRegistrationNum
	FROM
		[mnrBranch] [br]
		INNER JOIN [dbo].[mnrSysFnGetBranchSortList](@BranchID,1) AS [fbm] ON [fbm].[ID] = [br].[ID]
		
	IF( @BranchID = 0x0)
		INSERT INTO #Branch SELECT 0x0,'','','',@CommercialRegistrationNum

	--	SELECT * FROM #Branch

	-- ********************* #BillType ***************************** --

	Create table #BillType(	    ID		   UNIQUEIDENTIFIER,
	                            BranchID   UNIQUEIDENTIFIER,
	                            Name       NVARCHAR(512)  COLLATE Arabic_CI_AI NULL,
                                Type       INT,
							    bInOut     INT,
								bvat            INT,
								bttc            INT
				  	     )
	INSERT INTO #BillType				  	 
		SELECT DISTINCT
			ISNULL(bt.ID,0x0), 
			ISNULL(bt.DefBranchID,0x0), 
			BT.Name,
			bt.Type,
			bt.bInOut,
			ISNULL(bt.bVAT,0),
			ISNULL(bt.bTTC,0)
		FROM
			mnrBillType bt
        WHERE     
		          (Type = 3)
			 OR   (Type = 5)

  --SELECT * FROM #BillType

--------------------------------------------------
  	Create table #ExpanseType(	    ID		           UNIQUEIDENTIFIER,
	                                PayTypeName        NVARCHAR(256) COLLATE ARABIC_CI_AI NULL
				  			  )
	insert into #ExpanseType				  	 
		SELECT 
			intbt.BillTypeID,
			PayType.ptName
		FROM
			mnrEGIntBillType intbt
			INNER JOIN mnrVcPayType   PayType                            ON intbt.BillTypeID = PayType.ptID
            INNER JOIN [dbo].[mnrSysFnGetSrcTypeList]( @RepSrcID) AS src ON src.TypeID = PayType.ptID
	 --SELECT * FROM  #ExpanseType


	-- ********************* #Result ***************************** --

	CREATE TABLE #Result (
	                       OpID		       UNIQUEIDENTIFIER ,
						   OpNum           FLOAT NULL,
						   OpTypeName	   NVARCHAR(512)  COLLATE Arabic_CI_AI NULL,
						   OpTypeID		   UNIQUEIDENTIFIER NULL,
						   OpType          INT NULL,
						   CommercialRegistrationNum         NVARCHAR(512) COLLATE Arabic_CI_AI NULL,
						   bCoreFlag            INT NULL,

						   AccID	   UNIQUEIDENTIFIER NULL,
					       AccCode     NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
					       AccTaxCode  NVARCHAR(256)  COLLATE Arabic_CI_AI NULL, 
						   AccName     NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   AccLName    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL,

						   CustID	   UNIQUEIDENTIFIER NULL,
						   CustCode    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   CustName    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   CustLName   NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 

						   SMID	   UNIQUEIDENTIFIER NULL,
						   SMCode    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   SMName    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   SMLName   NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   ---
						   StoreID	   UNIQUEIDENTIFIER NULL,
						   StoreCode    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   StoreName    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   StoreLName   NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   --
						   BranchID	   UNIQUEIDENTIFIER NULL,
						   BranchCode    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   BranchName    NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 
						   BranchLName   NVARCHAR(512)  COLLATE Arabic_CI_AI NULL, 

						   OpDate	   DATETIME NULL,
						   OpSentDate  DATETIME  NULL, 
						   OpStatus    INT NULL, 
						   OpStrOpStatus NVARCHAR(max)  COLLATE Arabic_CI_AI NULL,
						   OpCause       NVARCHAR(max)  COLLATE Arabic_CI_AI NULL,
						  -- OpSent      INT, 

						   ApiResponse NVARCHAR(512)NULL,
						   OpTotalItem FLOAT NULL,
						   OpTotal     FLOAT NULL,
						   OpVat       FLOAT NULL,
						   Flag           INT NULL ,-- 1 bills,2 entry
						   SystemFlag     INT NULL, -- eygpt = 3 ,syrian =4,saudi=5  ,
						   EBillType      INT NULL  -- 
						  )
						  
	IF(@SentStatus!=2)-- 1 = sent , 0 = both
	BEGIN
		 INSERT INTO #Result
		 SELECT DISTINCT
			bf.BID,
			bf.BNumber,
			bt.Name, 
			bt.ID,
			bt.type,

			br.CommercialRegistrationNum,
			ISNULL(bn.bCoreFlag,0),

			ISNULL(bf.BAccAccountID,0x0),
			ISNULL(a.AccCode,''),
			ISNULL(a.AccTaxCode,''),
			ISNULL(a.AccName,''),
			ISNULL(a.AccLName, ''),

			ISNULL(a.CustID,0x0),
			ISNULL(a.CustCode,''),
			ISNULL(a.CustName,''),
			ISNULL(a.CustLName, ''),

			ISNULL(sm.ID,0x0),
			ISNULL(sm.Code,''),
			ISNULL(sm.Name,''),
			ISNULL(sm.LName, ''),

			ISNULL(st.ID,0x0),
			ISNULL(st.Code,''),
			ISNULL(st.Name,''),
			ISNULL(st.LName, ''),

			ISNULL(br.ID,0x0),
			ISNULL(br.Code,''),
			ISNULL(br.Name,''),
			ISNULL(br.LName, ''),


			bf.BTimeIn,
			CASE WHEN ISNULL(bn.bCoreFlag,0)=@bCoreFlag  THEN bn.Date else '1980-01-01'    END,
			CASE WHEN ISNULL(bn.bCoreFlag,0)=@bCoreFlag  THEN bn.status else 0    END,
			bn.StatusResponse,
			bn.Response,
			CASE WHEN ISNULL(bn.bCoreFlag,0)=@bCoreFlag  THEN bn.BillApiResponse else ''    END,
			CASE WHEN bt.bvat = 0 THEN bf.FixBTotalItem - bf.FixBVAT else bf.FixBTotalItem    END,
			bf.FixBTotal ,
			bf.FixBVat,
			1,
			SystemFlag,
			ISNULL(bf.BEBillType,0)
		 FROM 
			mnrVWBillIntegration bn 
			INNER JOIN mnrFnBI_Fixed(@CurrencyID) bf on bf.BID = bn.BillID
			INNER JOIN [dbo].[mnrSysFnGetSrcTypeList]( @RepSrcID) AS [Src]  ON [Src].[TypeID]   = [bf].[BBillTypeID]
			INNER JOIN #BillType bt        on bt.ID    = bf.BBillTypeID
			INNER JOIN #Acc a              on a.AccID  = ISNULL(bf.BAccCustID   , 0x0)
			INNER JOIN #CostJob c          on c.ID     = ISNULL(bf.biCostJobID  , 0x0)
			INNER JOIN #SellMan sm         on sm.ID    = ISNULL(bf.biSalesmanID , 0x0)
			INNER JOIN #Branch br          on br.ID    = ISNULL(bf.BBranchID, 0x0)
			INNER JOIN #Store st           on st.ID    = ISNULL(bf.BStoreID, 0x0)
		WHERE 
			 bf.BDate BETWEEN @FromDate AND @ToDate 
			 AND  (bn.SystemFlag  !=2) 
			 AND  (ISNULL(bf.BEBillType,0)=@EBillType OR @EBillType=2)
			 AND (bn.Status !=0)
			 AND ((   (@Systemflag = 2  AND   ( @BillStatus =  1 AND (bn.Status =1 OR bn.Status =3) and (ISNULL(bn.bCoreFlag,0)=@bCoreFlag ) ) --SAUDI
			                            OR    ( @BillStatus =  2 AND (bn.Status =2 OR bn.Status =4 and ( ISNULL(bn.bCoreFlag,0)=@bCoreFlag    ) )))

			        OR(@Systemflag = 1  AND   ( @BillStatus =  1 AND bn.Status =1 ) --EGYPT
				                        OR    ( @BillStatus =  2 AND bn.Status =2 ) 
									    OR    ( @BillStatus =  3 AND bn.Status =3 ) 
									    OR    ( @BillStatus =  4 AND bn.Status =4 ) )

					OR(@Systemflag = 5  AND   ( @BillStatus =  1 AND bn.Status =1) --syrian 
						   	            AND   (   ( CASE  WHEN bt.Type=5  THEN ISNULL(bf.BLinkID,0x0) END)  !=0x0         
 				                           OR (bt.Type !=5 ) 
				                             )
									    ) 
			 ) 
			 OR (@BillStatus=0 ))


			  IF(@Systemflag =5)
			   BEGIN
		         INSERT INTO #Result
					 SELECT DISTINCT
						e.EID,
						e.ENumber,
						paytype.PayTypeName, 
						paytype.ID,
						1,
						'',--br.CommercialRegistrationNum,
			            ISNULL(bn.bCoreFlag,0),

						a.AccID ,
						ISNULL(a.AccCode,''),
						ISNULL(a.AccTaxCode,''),
						ISNULL(a.AccName,''),
						ISNULL(a.AccLName, ''),

						0x0,
						'',
						'',
						'',

						--
						ISNULL(sm.ID,0x0),
						ISNULL(sm.Code,''),
						ISNULL(sm.Name,''),
						ISNULL(sm.LName, ''),

						0x0,
						'',
						'',
						'',

						0x0,
						'',
						'',
						'',

						E.ECDate,
						bn.Date,
						bn.status,
						bn.StatusResponse,
						bn.Response,
						bn.BillApiResponse,
						SUM(ISNULL(FixEIDebit,0)),
						SUM(ISNULL(FixEIDebit,0)),
						0,
						1,
						SystemFlag,
						0
					 FROM #ExpanseType paytype 	
						INNER JOIN   mnrFnEI_Fixed(@CurrencyID) e  ON paytype.ID   = e.EEntryTypeID
						INNER JOIN	 mnrVWBillIntegration       bn ON e.EID        = bn.BillID
						INNER JOIN #Acc a                          ON a.AccID      = ISNULL(e.IAccID , 0x0)
						INNER JOIN #CostJob c                      ON c.ID         = ISNULL(e.ICostJobID  , 0x0)
						INNER JOIN #SellMan sm                      ON sm.ID         = ISNULL(e.ISalesmanID , 0x0)
						
					WHERE 
						 E.EDate BETWEEN @FromDate AND @ToDate
						  and ISNULL(FixEIDebit,0)>0
						 AND (bn.Status !=0)
						 AND (
								(
								  @BillStatus =  1 AND bn.Status =1
								) --syrian 													   
						     
						  OR @BillStatus=0)
					 GRoup BY  
								e.EID,
								e.ENumber,
						        paytype.PayTypeName, 
					         	paytype.ID,
								a.AccID ,
								ISNULL(a.AccCode,''),
								ISNULL(a.AccTaxCode,''),
								ISNULL(a.AccName,''),
								ISNULL(a.AccLName, ''),
								ISNULL(sm.ID,0x0),
								ISNULL(sm.Code,''),
								ISNULL(sm.Name,''),
								ISNULL(sm.LName, ''),
								E.ECDate,
								bn.Date,
								bn.status,
								bn.StatusResponse,
								bn.Response,
								bn.BillApiResponse,
								SystemFlag
								

	  END
	END

	--select * from #Result

	IF(@SentStatus !=1)-- 2 = not sent , 0 = both
	BEGIN
	-- -- print 'not sent totally'
	-- -- not sent totally
	 INSERT INTO #Result
	 SELECT DISTINCT 
			bf.BID,
			bf.BNumber , 
			bt.Name,
			bt.ID,
			bt.type,
			br.CommercialRegistrationNum,
			ISNULL(r.bCoreFlag,0),

			ISNULL(bf.BAccAccountID,0x0),
			ISNULL(a.AccCode,''),
			ISNULL(a.AccTaxCode,''),
			ISNULL(a.AccName,''),
			ISNULL(a.AccLName, ''),

			ISNULL(a.CustID,0x0),
			ISNULL(a.CustCode,''),
			ISNULL(a.CustName,''),
			ISNULL(a.CustLName, ''),



			ISNULL(sm.ID,0x0),
			ISNULL(sm.Code,''),
			ISNULL(sm.Name,''),
			ISNULL(sm.LName, ''),

			ISNULL(st.ID,0x0),
			ISNULL(st.Code,''),
			ISNULL(st.Name,''),
			ISNULL(st.LName, ''),

			ISNULL(br.ID,0x0),
			ISNULL(br.Code,''),
			ISNULL(br.Name,''),
			ISNULL(br.LName, ''),

			bf.BTimeIn,
			'1-1-1980',
		
			0,-- sentStatus
			N'',
			ISNULL(R.Response, ''),
			'',
			CASE WHEN bt.bvat = 0 THEN bf.FixBTotalItem - bf.FixBVAT else bf.FixBTotalItem    END,
			bf.FixBTotal ,
			bf.FixBVat,
			1,
			@Systemflag,
		ISNULL(bf.BEBillType,0)
	 FROM 
		mnrFnBI_Fixed(@CurrencyID) bf 
		Left join mnrBillIntegration r  ON bf.BID = r.BillID and r.SystemFlag != 2 
		INNER JOIN [dbo].[mnrSysFnGetSrcTypeList]( @RepSrcID) AS [Src]  ON [Src].[TypeID]   = [bf].[BBillTypeID]
		INNER JOIN  #BillType bt         ON bt.ID = bf.BBillTypeID
		INNER JOIN  #Acc a               ON a.AccID = bf.BAccAccountID 
		INNER JOIN  #CostJob c           ON c.ID = bf.biCostJobID
		INNER JOIN  #SellMan sm          ON sm.ID = bf.biSalesmanID
		INNER JOIN  #Branch br           ON br.ID    = ISNULL(bf.BBranchID , 0x0)
		INNER JOIN #Store st             on st.ID    = ISNULL(bf.BStoreID, 0x0)
	WHERE
		(r.BillID IS NULL OR(r.Status=0))
		AND bf.BDate BETWEEN @FromDate and @ToDate
		AND(     (@Systemflag = 5  		         AND      ( CASE  WHEN bt.Type=5  THEN ISNULL(bf.BLinkID,0x0) END)  !=0x0  
 				                                 OR (bt.Type !=5 ) )
				OR @Systemflag !=5

			)
             
	    	                          

									 

	IF(@Systemflag =5)
			   BEGIN
		         INSERT INTO #Result
					 SELECT DISTINCT
						e.EID,
						e.ENumber,
						paytype.PayTypeName, 
						paytype.ID,
						1,
						'',--br.CommercialRegistrationNum,
			            ISNULL(bn.bCoreFlag,0),
						a.AccID ,
						ISNULL(a.AccCode,''),
						ISNULL(a.AccTaxCode,''),
						ISNULL(a.AccName,''),
						ISNULL(a.AccLName, ''),

						0x0,
						'',
						'',
						'',

						ISNULL(sm.ID,0x0),
						ISNULL(sm.Code,''),
						ISNULL(sm.Name,''),
						ISNULL(sm.LName, ''),

						0x0,
						'',
						'',
						'',

						0x0,
						'',
						'',
						'',

						E.ECDate,
						bn.Date,
						bn.status,
						bn.StatusResponse,
						bn.Response,
						bn.BillApiResponse,
						SUM(ISNULL(FixEIDebit,0)), 
						SUM(ISNULL(FixEIDebit,0)),
						0,
						1,
						SystemFlag,
						0
					 FROM  #ExpanseType paytype	 
						INNER JOIN  mnrFnEI_Fixed(@CurrencyID) e         ON paytype.ID         = e.EEntryTypeID
						LEFT JOIN	mnrVWBillIntegration       bn		 ON e.EID        = bn.BillID
						INNER JOIN #Acc a								 ON a.AccID      = ISNULL(e.IAccID , 0x0)
						INNER JOIN #CostJob c                            ON c.ID         = ISNULL(e.ICostJobID  , 0x0)
						INNER JOIN #SellMan sm                           ON sm.ID         = ISNULL(e.ISalesmanID , 0x0)
					WHERE 
						 E.EDate BETWEEN @FromDate AND @ToDate 
                         AND (bn.BillID IS NULL OR(bn.Status=0))
						 and ISNULL(FixEIDebit,0)>0
					 GRoup BY  
								e.EID,
								e.ENumber,
								paytype.PayTypeName, 
								paytype.ID,
								a.AccID ,
								ISNULL(a.AccCode,''),
								ISNULL(a.AccTaxCode,''),
								ISNULL(a.AccName,''),
								ISNULL(a.AccLName, ''),
								ISNULL(sm.ID,0x0),
								ISNULL(sm.Code,''),
								ISNULL(sm.Name,''),
								ISNULL(sm.LName, ''),
								E.ECDate,
								bn.Date,
								bn.status,
								bn.StatusResponse,
								bn.Response,
								bn.BillApiResponse,
								SystemFlag			
				
			  END

   END

-- final result 

	SELECT * FROM #Result
	ORDER BY 
	             OpType,
				 OpNum ,
				 OpID
				 
--#END#
