CREATE OR ALTER  PROCEDURE [dbo].[mnrPrcWebSynchInitialize] 	
AS 
    DECLARE @TableName NVARCHAR(128)
	DECLARE @sql varchar(MAX)
    DECLARE @cursor_name CURSOR
	
	SET @cursor_name = CURSOR FAST_FORWARD FOR 
			SELECT
				m.TblName
			FROM 
				mnrRepBranchesStatements s
			   INNER JOIN mnrRepTableMain m ON s.mnrRepTableMainID = m.id

    OPEN @cursor_name

    FETCH FROM @cursor_name INTO @TableName
  -- Enable  TRIGGER trg_mnr_rep_tbl_mnrMaterial  ON mnrMaterial
    WHILE @@FETCH_STATUS = 0
    BEGIN   
	
					-- Build the dynamic SQL statement
					SET @sql = 'DISABLE TRIGGER ALL ON ' + QUOTENAME(@TableName) + ';' + CHAR(13) + CHAR(10);

					SET @sql = @sql + 'ENABLE TRIGGER trg_mnr_rep_tbl_' + @TableName + ' ON ' + QUOTENAME(@TableName) + ';' + CHAR(13) + CHAR(10);

					SET @sql = @sql +
						'UPDATE t1 ' +
						'SET t1.ID = t1.ID ' +  -- This appears to be a dummy update to trigger something
						'FROM ' + QUOTENAME(@TableName) + ' t1 ' +
						'LEFT JOIN mnrRepTblsRecAction t2 ON t1.ID = t2.RecGUID ' +
						'WHERE t2.RecGUID IS NULL;' + CHAR(13) + CHAR(10);

					SET @sql = @sql + 'ENABLE TRIGGER ALL ON ' + QUOTENAME(@TableName) + ';';

					-- Print for debugging (optional)
					PRINT 'Executing dynamic SQL on table: ' + @TableName;
					PRINT @sql;
	         
 
			 
			print @TableName
		    print @sql
			EXEC ( @sql)
			
        FETCH FROM @cursor_name INTO @TableName
    END
	
  -- select * from mnrRepTableMain
    CLOSE @cursor_name
    DEALLOCATE @cursor_name


--#END#